//
//  MCAutoScrollView.h
//  MCApplication
//
//  Created by Alykhan Jetha on Sun May 25 2003.
//  Copyright (c) 2003 __MyCompanyName__. All rights reserved.
//

#import "MCScrollView.h"

/*!
	@class MCAutoScrollView
	A class the allows you to set a minimum documentView size. If the frame of a MCAutoScrollView becomes smaller than the minimum width or height set here, scrollers will appear. If the frame of the MCAutoScrollView become larger, then the document view is asked to resize accordingly. The default scrollview behaviour is to increase the size of clipview but not the document view.
*/
@interface MCAutoScrollView : MCScrollView
{
	float	minHeight;
	float	minWidth;
}

/*!
	@method setMininumDocumentViewWidth: height:
	@abstract Sets the minimum width and height of the document - if the scrollview's frame becomes smaller than this, then scrollers will appear. If the frame size becomes larger, then the scrollers disappear and the document is resized to accordingly.
	@param aWidth The minimum width before a scroll bar appears
	@param aHeight The minimum height before a scroll bar appears
*/
- (void)setMininumDocumentViewWidth:(float)aWidth height:(float)aHeight;

/*!
	@method scrollToTop
	@abstract Scrolls the document to the top left corner taking into consideration the minimum width and height set on this object. (non flipped coordinate system)
*/
- (void)scrollToTop;

/*!
	@method resizeView: proposedFrame:
	@abstract Resizes the view considering the minimum height and width. Displays or hide the scrollers as needed
	@param aView  the view to be resized
	@param frameRect  the proposed frame
	@result returns whether or not you should scroll to the top after the resize.
*/
- (BOOL)resizeView:(NSView *)aView proposedFrame:(NSRect)frameRect;

@end
